//--------------------------------------
// Disco Light Driver For the PIC12C50x
//           Version 4.00
//
//  Using HiTech - C Compiler
//
// Author: M.O.Pearce
//
// Started: 7 - October -1998
//--------------------------------------

//-- Pin assignments as follow --
//== OUTPUTS ==
// GP0 - Lamp Drive 0
// GP1 - Lamp Drive 1
// GP2 - Lamp Drive 2
// GP4 - Lamp Drive 3  **** Note it is GP4 cause GP3 is input only
//== INPUTS ==
// GP3 - Beat
// GP5 - Fast / Slow mode - indicates when music stops

#include <pic.h>
#define BITNUM(adr, bit)       ((unsigned)(&adr)*8+(bit))
#define MAXDATA 128  // Maximum amount of data in the array

static bit  Beat    @ BITNUM(GPIO, 3);  //- Beat input pin
static bit  Fast    @ BITNUM(GPIO, 5);  //- Sequ Select pin


unsigned char const PATTERN[MAXDATA] =
{
  0x17,0x0,0x17,0x0,0x17,0x0,0x17,0x0,
  0x10,0x4,0x2,0x1,0x10,0x04,0x02,0x01,
  0x1,0x1,0x17,0x10,0x10,0x17,0x01,0x01,
  0x17,0x7,0x3,0x1,0x0,0x10,0x14,0x16,
  0x7,0x13,0x15,0x16,0x07,0x13,0x15,0x16,
  0x0,0x10,0x0,0x1,0x0,0x4,0x0,0x2,
  0x0,0x0,0x1,0x0,0x0,0x2,0x0,0x0,
  0x6,0x11,0x06,0x11,0x06,0x11,0x06,0x11,
  0x14,0x3,0x14,0x03,0x14,0x3,0x14,0x3,
  0x1,0x3,0x7,0x17,0x7,0x3,0x1,0x0,
  0x14,0x6,0x3,0x14,0x06,0x03,0x0,0x0,
  0x10,0x10,0x1,0x1,0x10,0x10,0x01,0x01,
  0x4,0x4,0x2,0x2,0x10,0x10,0x01,0x01,
  0x17,0x17,0x17,0x0,0x17,0x0,0x17,0x17,
  0x2,0x6,0x7,0x17,0x16,0x6,0x4,0x0,
  0x10,0x2,0x4,0x1,0x2,0x10,0x1,0x4
};

unsigned char Pos;

//-----------------------------------------------------
void RunAuto(void);
unsigned char GetData(unsigned char Pointer);
void OutputData(unsigned char Data);
void ProcessDelay(unsigned char Data);


//*****************************************************
//  Main - Start of the program
//*****************************************************
void main (void)
{
 OPTION=0xDF;    //- T0CS has to be low so GP2 is output
 TRIS = 0x28;    //- GP0,1,2,4 = Out GP3,5 = In
 RunAuto();
}
//********** END OF main

//*****************************************************
// RunAuto - Runs the Standalone auto routines
//*****************************************************
void RunAuto(void)
{
 unsigned char Pointer,Data;
 Pointer=0;
 while(1) // Loop Forever
 {
  Data=GetData(Pointer);           //-- Get the data from the array
  OutputData(Data);                //-- Put data to the output port
  ProcessDelay(Data);              //-- Do required Time For data
  Pointer++;                       //-- Point to next data
  if(Pointer < MAXDATA) Pointer=0; //-- Check for roll around
 }
}
//********** END OF RunAuto
//*****************************************************
// GetData
//*****************************************************
unsigned char GetData(unsigned char Pointer)
{
  if(Pointer > MAXDATA) Pointer=0; //-- Check for end of data
  return(PATTERN[Pointer]);        //-- Read data from the array
}
//********** END OF GetData

//*****************************************************
// OutputData
//*****************************************************
void OutputData(unsigned char Data)
{
  GPIO=Data;                       //-- Output the data to Port
}
//********** END OF OutputData

//*****************************************************
//ProcessDelay
//*****************************************************
void ProcessDelay(unsigned char Data)
{
 unsigned char count;
 Data >> 5;
 Data &=0x07;
 Data += 1;
 for( ; Data > 0 ; Data--)
 {
  count=10;
  while(Fast == 0 && count > 0 ) //- If Fast = 0 then slow down
  {
   count--;
   while(Beat==0);   //-- Wait for Beat change (Max 9 times)
  }
  while(Beat==0);    //-- Wait for Beat change
 }
}
//********** END OF ProcessDelay

//*****************************************************
//
//*****************************************************
//********** END OF

//*****************************************************
//
//*****************************************************
//********** END OF






