//******************************************************************
//                      MakePat1.C
//                 Software Version 1.11
//        Make Pattern For Disco Light Firmware V4.00
// Software Runs on PC and generates an output file in form of a
// 'C' compatable hexadecimal data array.
//
// Author: M.O.Pearce
//
// Started: Wednesday 7 October 1998
//
//------------------------------------------------------------------
//  Version 1.00 - 7 Oct 1998 - Running without Emulation
//  Version 1.01 - 8 Oct 1998 - Running with the Emulator
//  Version 1.10 - 8 Oct 1998 - Added Save/load of data
//                            - Added Timing adjustment
//                            - Changed Display Pattern
//                            - Added Manual Control Option
//                            - Turned outputs off when finished
//  Version 1.11 -9 December  - Increased data size to 255 bytes
//
//******************************************************************
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <string.h>

#define MAXDATA 256


//#define LPTBASE 0x3BC
#define LPTBASE 0x378
//#define LPTBASE 0x278

unsigned char PATTERN[MAXDATA];

/*
struct BITS
{
 unsigned int a : 1 ;
 unsigned int b : 1 ;
 unsigned int c : 1 ;
 unsigned int sp : 1 ;
 unsigned int d : 1 ;
 unsigned int time : 3 ;
};
*/
struct BITS
{
 unsigned int a : 1 ;
 unsigned int b : 1 ;
 unsigned int c : 1 ;
 unsigned int d : 1 ;
 unsigned int sp : 1 ;
 unsigned int time : 3 ;
};

union
{
 char D;
 struct BITS b;
}Dat;

int OutMode=0;

#define MAXDELAY 500
#define MINDELAY  40    //-- Two AC Cycles
int DelayTime=200;


void CollectData(void);
void DisplayCurrent(unsigned char Position);
void DisplayData(unsigned char Position);
void ExportData(void);
void RunPattern(void);
void RunAuto(void);
unsigned char GetData(unsigned char Pointer);
void OutputData(unsigned char Data,unsigned char  Position);
void ProcessDelay(unsigned char Data);
void LoadData(void);
void SaveData(void);
void GetInput(char *result,int num);


//******************************************************************
// main
//******************************************************************
void main (void)
{
 clrscr();
 textcolor(GREEN);
 cprintf("                 Disco Light Pattern Builder Version 1.11");
 textcolor(LIGHTBLUE);
 cprintf("\r\n                      For Firmware Revision 4.00");
 textcolor(CYAN);
 cprintf("\r\n                      7 September 1998 M.O.Pearce");
 textcolor(YELLOW);
 cprintf("\r\n\nControls:\r\n1,2,3,4 = Channels\r\n");
 cprintf("\r\n+/- = Change 'ON' Time\r\nS/L = Save/Load Data");
 cprintf("\r\n[up][dwn] - Next/Previous\r\n[PgUp][PgDwn] = Up/Down 10");
 cprintf("\r\n[CR] = Next\r\nR = RUN\r\n[ESC] = Done");
 cprintf("\r\nZ = Manual Mode");
 cprintf("\r\nO,P = Adjust Run Delay");

 outportb(LPTBASE,0xFF);     //-- Clear Parallel Port

 CollectData();
 ExportData();

 outportb(LPTBASE,0xFF);     //-- Clear Parallel Port

 cprintf("\r\n\n All Done.... Hit key to quit");
 getch();
}
//**************** END OF main


//******************************************************************
//CollectData
//******************************************************************
void CollectData(void)
{
 int count,done=0,keyhit=0;
 unsigned char Position=0, PosChk=0;

 //-- Clear The Data --
 for(count=0;count<MAXDATA;count++)PATTERN[count]=0x7F; // lights off 1/2 time

 //-- Print the data collective on RH of Screen
 DisplayData(Position);
 //-- Print the data being worked on
 Dat.D=PATTERN[Position];
 DisplayCurrent(Position);

 //-- Get and modify the data
 while(done==0)
 {
  while(kbhit()==0);    //-- wait for keypress
  keyhit=getch();
  if(keyhit==0)
  {
   switch(getch())
   {
    case 0x48:
     PATTERN[Position]=Dat.D;
     Position--;
     if(Position >= MAXDATA) Position = MAXDATA-1;
     Dat.D=PATTERN[Position];
     break;

    case 0x49:
     PATTERN[Position]=Dat.D;
     Position-=10;
     if(Position >= MAXDATA) Position = MAXDATA-1; ;
     Dat.D=PATTERN[Position];
     break;


    case 0x50:
     PATTERN[Position]=Dat.D;
     Position++;
     if(Position >= MAXDATA) Position=0;
     Dat.D=PATTERN[Position];
     break;

    case 0x51:
     PATTERN[Position]=Dat.D;
     Position+=10;
     if(Position >= MAXDATA) Position=0;
     Dat.D=PATTERN[Position];
     break;
   }
  }
  else
  {
   switch(toupper(keyhit))
   {
    case '1':
     if(Dat.b.a==0)Dat.b.a=1;
     else Dat.b.a=0;
     break;

    case '2':
     Dat.b.b ++;
      break;

    case '3':
     Dat.b.c ++;
     break;

    case '4':
     Dat.b.d ++;
     break;

    case '+':
     Dat.b.time++;
     PATTERN[Position]=Dat.D;
     break;

    case '-':
     Dat.b.time--;
     PATTERN[Position]=Dat.D;
     break;

    case 0x0D:
     PATTERN[Position]=Dat.D;
     Position++;
     if(Position >= MAXDATA) Position=0;
     Dat.D=PATTERN[Position];
     break;

    case 'R':
     RunPattern();
     DisplayCurrent(Position);
     DisplayData(Position);
     break;

    case 'L':
     LoadData();
     Position=0; PosChk=1;
     Dat.D=PATTERN[Position];
     break;

    case 'S':
     SaveData();
     break;

    case 'P':
     DelayTime+=10;
     if(DelayTime > MAXDELAY)
     {
      DelayTime= MAXDELAY;
     }
     break;

    case 'O':
     DelayTime-=10;
     if(DelayTime < MINDELAY)
     {
      DelayTime= MINDELAY;
     }
     break;

    case 0x1B:
     done=1;
     break;

   case 'Z':
     if(OutMode==1)
     {
      OutMode=0;
      outportb(LPTBASE,0xFF);     //-- Clear Parallel Port
     }
     else
     {
      OutMode=1;
     }

    default:
     break;
   }
  }
  DisplayCurrent(Position);
  if(PosChk != Position)
  {
   DisplayData(Position);
   PosChk = Position;
  }
 }
}

//**************** END OF CollectData

//******************************************************************
//DisplayCurrent
//******************************************************************
void DisplayCurrent(unsigned char Position)
{
 int count;

 textcolor(WHITE);
 gotoxy(35,13);
 cprintf("1         4");
 gotoxy(35,16);
 cprintf("2         3");
 for (count=0;count<3;count++)
 {
  gotoxy(37,12+count);
  textcolor(RED);
  if(Dat.b.a==0) cprintf("***");
  else cprintf("---");

  gotoxy(41,12+count);
  textcolor(LIGHTBLUE);
  if(Dat.b.d==0) cprintf("***");
  else cprintf("---");

  gotoxy(37,15+count);
  textcolor(YELLOW);
  if(Dat.b.b==0) cprintf("***");
  else cprintf("---");

  gotoxy(41,15+count);
  textcolor(GREEN);
  if(Dat.b.c==0) cprintf("***");
  else cprintf("---");

 }
 textcolor(WHITE);
 cprintf("\r\n\nOn Time: %d x %d ms     ",Dat.b.time+1,DelayTime);
 cprintf("\r\nCurrent Position: %d  ",Position);
 cprintf("Current Ouput mode ");
 if(OutMode==1)
 {
  cprintf("ON    ");
  outportb(LPTBASE,Dat.D);     //-- Output the data to Parallel Port
 }
 else
 {
  cprintf("OFF    ");
 }
}
//**************** END OF DisplayCurrent

//******************************************************************
//DisplayData - Display array on R.H.S of screen - Highlite current
//******************************************************************
void DisplayData(unsigned char Position)
{
 unsigned char DatBack;
 unsigned char Number;
 int X=60,Y=3,count;

 //-- Save the Data --
 DatBack=Dat.D;

 gotoxy(X,Y);
 cprintf("POS 1 2 3 4 Time");
 Y++;
 for( count=0; count<20; count++)
 {
  Number=Position+count-10;
  if( Number < MAXDATA)
  {

   Dat.D=PATTERN[Number];
  }
  else
  {
   Number=Position+count-10-MAXDATA;
   Dat.D = PATTERN[Number];
  }

  if(count==10)
  {
   textbackground(BROWN);
  }
  else
  {
   textbackground(BLACK);
  }

  gotoxy(X,Y+count);
  textcolor(WHITE);
  cprintf("%3d ",Number);
  textcolor(RED);
  if(Dat.b.a==0) cprintf("*");
  else cprintf("-");
  textcolor(YELLOW);
  if(Dat.b.b==0) cprintf(" *");
  else cprintf(" -");
  textcolor(LIGHTGREEN);
  if(Dat.b.c==0) cprintf(" *");
  else cprintf(" -");
  textcolor(LIGHTBLUE);
  if(Dat.b.d==0) cprintf(" *");
  else cprintf(" -");
  textcolor(WHITE);
  cprintf("   %d ",Dat.b.time+1);
 }
 //-- Restore the data --
 Dat.D=DatBack;
}
//**************** END OF DisplayData

//******************************************************************
//ExportData
//******************************************************************
void ExportData(void)
{
 FILE *fptr;
 unsigned int count,col=1;

 cprintf("\r\nOpening File...");
 fptr=fopen("Discodat.c","w");
 cprintf("Exporting Data to Discodat.c......");
 fprintf(fptr,"\n//----- DISCO LIGHT DATA FOLLOWS -------");
 fprintf(fptr,"\n//--- Built using Make Pattern V1.00 ---");
 fprintf(fptr,"\n//-- Written By M.O.Pearce Sept 1998 ---");
 fprintf(fptr,"\n#define MAXDATA  %d",MAXDATA);
 fprintf(fptr,"\nunsigned char const PATTERN[MAXDATA] =\n{\n ");
 fprintf(fptr,"0x%X",PATTERN[0]);
 for(count=1;count<MAXDATA;count++)
 {
  fprintf(fptr,",0x%X",PATTERN[count]);
  col++;
  if(col==8)
  {
   col=0;
   fprintf(fptr,"\n ");
  }

 }
 fprintf(fptr,"\n};\n //-- End of Data");
 cprintf("Closing file...");
 fclose(fptr);
}
//**************** END OF SaveData

//******************************************************************
//RunPattern
//******************************************************************
void RunPattern(void)
{
 gotoxy(2,23);
 cprintf("Running Sequence - Hit key to stop................");
 RunAuto();
 gotoxy(2,23);
 cprintf("                                                   ");


}
//**************** END OF RunPattern

//*****************************************************
// RunAuto - Runs the Standalone auto routines
//*****************************************************
void RunAuto(void)
{
 unsigned char Pointer,Data,olddat;
 olddat=Dat.D;

 Pointer=0;
 while(!kbhit()) // Loop until Key Hit
 {
  Data=GetData(Pointer);           //-- Get the data from the array
  Dat.D=Data;
  OutputData(Data,Pointer);        //-- Put data to the output port
  ProcessDelay(Data);              //-- Do required Time For data
  Pointer++;                       //-- Point to next data
  if(Pointer >= MAXDATA) Pointer=0; //-- Check for roll around
 }
 getch(); //--clear buffer.
 Dat.D=olddat;
}
//********** END OF RunAuto
//*****************************************************
// GetData
//*****************************************************
unsigned char GetData(unsigned char Pointer)
{
  return(PATTERN[Pointer]);        //-- Read data from the array
}
//********** END OF GetData

//*****************************************************
// OutputData
//*****************************************************
void OutputData(unsigned char Data,unsigned char  Position)
{
 DisplayCurrent(Position);
 DisplayData(Position);
 outportb(LPTBASE,Data);     //-- Output the data to Parallel Port
}
//********** END OF OutputData

//*****************************************************
//ProcessDelay
//*****************************************************
void ProcessDelay(unsigned char Data)
{
// unsigned char count;
 Data=Data >> 5;
 Data &=0x07;
 Data += 1;
 for( ; Data > 0 ; Data--)
 {
//  count=10;
//  while(Fast == 0 && count > 0 ) //- If Fast = 0 then slow down
//  {
//   count--;
//   while(Beat==0);   //-- Wait for Beat change (Max 9 times)
//  }
//  while(Beat==0);    //-- Wait for Beat change
  delay(DelayTime);
 }
}
//********** END OF ProcessDelay


//******************************************************************
//LoadData
//******************************************************************
void LoadData(void)
{
 FILE *fptr;
 char filename[17];
 int count;

 gotoxy(1,20);
 cprintf("Enter .dco File name to Load: ");
 GetInput(filename,8);
 strcat(filename,".dco");
 fptr=fopen(filename,"r");
 if(fptr==NULL)
 {
  gotoxy(1,20);
  cprintf("Error Opening File .... Hit key to continue...");
  getch();
  gotoxy(1,20);
  cprintf("                                               ");
  return;
 }

 for(count=0;count<MAXDATA;count++)
 {
  PATTERN[count]=fgetc(fptr);
 }
 fclose(fptr);
 gotoxy(1,20);
 cprintf("                                               ");
}
//**************** END OF LoadData

//******************************************************************
//SaveData
//******************************************************************
void SaveData(void)
{
 FILE *fptr;
 char filename[17];
 int count;

 gotoxy(1,20);
 cprintf("Enter .dco File name to Save : ");
 GetInput(filename,8);
 strcat(filename,".dco");
 fptr=fopen(filename,"w");
 if(fptr==NULL)
 {
  gotoxy(1,20);
  cprintf("Error Opening File .... Hit key to continue...");
  getch();
  gotoxy(1,20);
  cprintf("                                               ");
  return;
 }
 for(count=0;count<MAXDATA;count++)
 {
  fputc(PATTERN[count],fptr);
 }

 fclose(fptr);
 gotoxy(1,20);
 cprintf("                                               ");
}
//**************** END OF SaveData

//******************************************************************
//GetInput
//******************************************************************
void GetInput(char *result,int num)
{
 int ptr=0,done=0,key,count;
 char string[80]="";
 struct text_info ti;
 gettextinfo(&ti);

 while(done==0)
 {
  for(count=0;string[count]!=NULL;count++)
  {
   gotoxy(ti.curx+count,ti.cury);
   putch(string[count]);
  }
  for(;count<=num;count++)
  {
   gotoxy(ti.curx+count,ti.cury);
   putch(' ');
  }
  key=getch();
  if(key==0)
  {
   //-- check for extended keys
   gotoxy(1,1);
   cprintf("Key Code: 0x%X  ",getch());
//   switch(getch())
//   {
//    case 0:
//     break;
//   }
  }
  else
  {
   //-- check for basic Keys
   switch(key)
   {
    case 0x0d:         //-- Return Key
     done=1;
     string[ptr]=NULL;
     break;

    case 0x08:         //-- Backspace Key
     if(ptr >0)
     {
      string[ptr]=NULL;
      ptr--;
     }
     string[ptr]=NULL;
     break;

    default:
     string[ptr]=key;
     ptr++;
     if(ptr >= num)
     {
      ptr=num;
     }
     string[ptr]=NULL;
     break;
   }
  }
 }
 strcpy(result,string);
}
//**************** END OF GetInput

//******************************************************************
//
//******************************************************************

//**************** END OF


